﻿using System.ComponentModel;
using System;
using System.Windows.Threading;
using System.Windows;
using TwoCamWPF.Helpers;


namespace TwoCamWPF.Settings
{
    internal abstract class BaseViewModel<T> : BaseViewModel// where T : ISubSettings
    {
        protected T _settings;

        public BaseViewModel(T elem): base() {
            _settings = elem;
         }


    }

    internal abstract class BaseViewModel : INotifyPropertyChanged
    {

        public BaseViewModel()
        {

        }

        #region INotifyPropertyChanged Members

        protected void RaisePropertyChanged(string p)
        {
            if (PropertyChanged == null)
                return;
            if (Dispatcher == null)
                return;
            if (Dispatcher.CheckAccess())
            {
                PropertyChanged(this, new PropertyChangedEventArgs(p));
            }
            else
            {
                Dispatcher.BeginInvoke(new Action(() => RaisePropertyChanged(p)));
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        public static Dispatcher Dispatcher
        {
            get
            {
                if (Application.Current != null)
                {
                    return System.Windows.Threading.Dispatcher.CurrentDispatcher;
                  //   return Application.Current.Dispatcher;
                }
                else
                    return null;

            }


        }

        #endregion
    }
}